/*
 * @(#)OMMethodFigure.java  2.0  2006-01-16
 *
 * Copyright (c) 2003-2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.oo.diagram;

import ch.hslu.cm.simulation.*;
import ch.hslu.cm.oo.*;
import ch.hslu.cm.oo.objectmodel.*;
import java.awt.*;
import java.awt.geom.*;
import java.awt.font.*;
import java.io.IOException;
import java.util.*;
import static org.jhotdraw.draw.AttributeKeys.*;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.TextAreaFigure;
import org.jhotdraw.draw.handle.CloseHandle;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.handle.ResizeHandleKit;
import org.jhotdraw.geom.*;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/**
 * OMMethodFigure visually represents a {@link OMMethod}.
 * 
 * @author Werner Randelshofer
 * @version 2.0 2006-01-16 Changed to support double precision coordinates.
 * <br>1.0 8. März 2004  Created.
 */
public class OMMethodFigure extends TextAreaFigure implements SimulatedObjectListener, OMClassListener {
    private OMClassFigure model;
    private int operationIndex;
    
    /** Creates a new instance. */
    public OMMethodFigure() {
        FILL_COLOR.set(this, ClassDiagram.METHOD_FILL_COLOR);
        STROKE_COLOR.set(this, ClassDiagram.METHOD_STROKE_COLOR);
        setAttributeEnabled(TEXT, false);
        FONT_FACE.set(this, new Font("Verdana", Font.PLAIN, 0));
    }
    
    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        if (detailLevel == 0) {
        handles.add(ResizeHandleKit.northWest(this));
        handles.add(ResizeHandleKit.southWest(this));
        handles.add(ResizeHandleKit.southEast(this));
        handles.add(new CloseHandle(this));
        }
        return handles;
    }
    /**
     * Returns the insets used to draw text.
     */
    @Override
    public Insets2D.Double getInsets() {
        int sw = (int) Math.ceil(STROKE_WIDTH.get(this) / 2);
        Insets2D.Double insets = new Insets2D.Double(10,4,4,4);
        if (getModel() != null) {
            LineMetrics lm = getFont().getLineMetrics(getModel().getModel().getOperation(operationIndex).getName(), getFontRenderContext());
            insets.top += (int) Math.ceil(lm.getHeight());
        }
        return new Insets2D.Double(insets.top+sw,insets.left+sw,insets.bottom+sw,insets.right+sw);
    }
    
    
    public void setModel(OMClassFigure classFigure, int operationIndex) {
        if (this.model != null) {
            this.model.getModel().removeSimulatedObjectListener(this);
            this.model.getModel().removeSimulatedClassListener(this);
        }
        this.model = classFigure;
        this.operationIndex = operationIndex;
        if (model != null) {
            model.getModel().addSimulatedObjectListener(this);
            model.getModel().addSimulatedClassListener(this);
        }
        fireAreaInvalidated();
    }
    public OMClassFigure getModel() {
        return model;
    }
    
    @Override
    public void set(AttributeKey key, Object value) {
        if (model != null && key.equals(TEXT)) {
            model.getModel().setOperationMethod(operationIndex, (String) value);
        } else {
            super.set(key, value);
        }
    }
    @Override
    public Object get(AttributeKey key) {
        if (model != null && key.equals(TEXT)) {
            return model.getModel().getOperation(operationIndex).getMethod();
        } else {
            return super.get(key);
        }
    }
    protected void drawConnectors(Graphics2D g) {
        Rectangle2D.Double b = getBounds();
        g.setColor(ClassDiagram.METHOD_CONNECTOR_COLOR);
        g.setStroke(new BasicStroke());
        BezierPath p = new BezierPath();
        p.add(b.x + 1, b.y + 1);
        p.add(b.x + b.width - 1, b.y + 1);
        p.add(b.x + b.width - 1, b.y + b.height - 11);
        p.add(b.x + b.width - 11, b.y + b.height - 1);
        p.add(b.x + 1, b.y + b.height - 1);
        g.draw(p);
    }
    @Override
    protected void drawFill(Graphics2D g) {
        Rectangle2D.Double b = getBounds();
        BezierPath p = new BezierPath();
        p.add(b.x, b.y);
        p.add(b.x + b.width, b.y);
        p.add(b.x + b.width, b.y + b.height - 10);
        p.add(b.x + b.width - 10, b.y + b.height);
        p.add(b.x, b.y + b.height);
        g.fill(p);
    }
    @Override
    protected void drawStroke(Graphics2D g) {
        Rectangle2D.Double b = getBounds();
        Insets2D.Double insets = getInsets();
        BezierPath p = new BezierPath();
        p.add(b.x, b.y);
        p.add(b.x + b.width, b.y);
        p.add(b.x + b.width, b.y + b.height - 10);
        p.add(b.x + b.width - 10, b.y + b.height);
        p.add(b.x, b.y + b.height);
        p.setClosed(true);
        g.draw(p);
        g.draw(new Line2D.Double(b.x + b.width - 10, b.y + b.height, b.x + b.width - 10, b.y + b.height - 10));
        g.draw(new Line2D.Double(b.x + b.width - 10, b.y + b.height - 10, b.x + b.width, b.y + b.height - 10));
    }
    @Override
    protected void drawText(Graphics2D g) {
        if (model != null) {
            Font f = getFont().deriveFont(Font.BOLD);
            g.setFont(f);
            Rectangle2D.Double b = getBounds();
            Insets2D.Double insets = getInsets();
            String title = getModel().getModel().getOperation(operationIndex).getName();
            LineMetrics lm = getFont().getLineMetrics(title, getFontRenderContext());
            Shape savedClip = g.getClip();
            g.setClip(new Rectangle2D.Double(b.x, b.y, b.width, b.y + insets.top));
            g.drawString(title, (float) (b.x + insets.left), (float) (b.y + insets.top - 8 - (int) lm.getDescent()));
            g.setClip(savedClip);
        }
        super.drawText(g);
    }
    
    @Override
    public void relationshipAdded(SimulatedObjectEvent e) {
    }
    
    @Override
    public void objectAdded(SimulatedObjectEvent e) {
    }
    
    @Override
    public void relationshipRemoved(SimulatedObjectEvent e) {
    }
    
    @Override
    public void objectChanged(SimulatedObjectEvent e) {
    }
    
    @Override
    public void objectRequestRemove(SimulatedObjectEvent e) {
    }
    
    @Override
    public void objectRemoved(SimulatedObjectEvent e) {
        System.out.println(this+" removedFromSimulation:"+e.getObject()+"=="+(e.getObject() == model.getModel()));
        setModel(null, -1);
        fireFigureRequestRemove();
    }
    
    @Override
    public void attributeAdded(OMClassEvent event) {
    }
    
    @Override
    public void attributeChanged(OMClassEvent event) {
    }
    
    @Override
    public void attributeRemoved(OMClassEvent event) {
    }
    
    @Override
    public void generalizationChanged(OMClassEvent event) {
    }
    
    @Override
    public void nameChanged(OMClassEvent event) {
    }
    @Override
    public void abstractChanged(OMClassEvent event) {
    }
    
    @Override
    public void operationAdded(OMClassEvent event) {
        if (event.getIndex() < operationIndex) operationIndex++;
    }
    
    @Override
    public void operationChanged(OMClassEvent event) {
        if (event.getIndex() == operationIndex) {
            fireAreaInvalidated(getDrawingArea());
        }
    }
    
    @Override
    public void operationRemoved(OMClassEvent event) {
        if (event.getIndex() < operationIndex) operationIndex--;
        else if (event.getIndex() == operationIndex) {
            setModel(null, -1);
            fireFigureRequestRemove();
        }
    }
    
    public void remap(Map oldToNew) {
        System.out.println(this+" remap");
        if (oldToNew.containsKey(model)) {
            model.getModel().removeSimulatedClassListener(this);
            model.getModel().removeSimulatedObjectListener(this);
            model = (OMClassFigure) oldToNew.get(model);
            model.getModel().addSimulatedClassListener(this);
            model.getModel().addSimulatedObjectListener(this);
            fireAreaInvalidated();
        }
    }
    
    @Override
    public void read(DOMInput in) throws IOException {
        in.openElement((in.getElementCount("model") == 1) ? "model" : "Model");
        setModel((OMClassFigure) in.readObject(0), in.getAttribute("index", -1));
        in.closeElement();
        readBounds(in);
        readAttributes(in);
    }
    @Override
    public void write(DOMOutput out) throws IOException {
        out.openElement("Model");
        out.writeObject(getModel());
        out.addAttribute("index", operationIndex);
        out.closeElement();
        writeBounds(out);
        writeAttributes(out);    
    }
    
    @Override
    public OMMethodFigure clone() {
        OMMethodFigure that = (OMMethodFigure) super.clone();
        that.model.getModel().addSimulatedClassListener(that);
        that.model.getModel().addSimulatedObjectListener(that);
        return that;
    }
    @Override
    public int getLayer() {
        return ClassDiagram.MESSAGE_LAYER;
    }
}
